package app.firezone.synk.network.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import app.firezone.synk.network.Activities.ClaasicWinnerActivity;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ResultMatchBinding;
import app.firezone.synk.network.model.ResultModel;

public class LudoResultAdapter extends RecyclerView.Adapter<LudoResultAdapter.holder> {


    Context mContext;
    ArrayList<ResultModel> models = new ArrayList<ResultModel>();


    public LudoResultAdapter(ArrayList<ResultModel> models, Context mContext ) {
        this.mContext = mContext;
        this.models = models;
    }

    public void updateList(ArrayList<ResultModel> newList) {
        models.clear();
        models.addAll(newList);
        notifyDataSetChanged();
    }


    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.result_match,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, int position) {

        ResultModel list = models.get(position);

        // Set initial match data

        holder.binding.dateTxt.setText(list.getDate());
        holder.binding.timeTxt.setText(list.getTime());
        holder.binding.prizepool.setText("₹" +list.getPrizepool());
        holder.binding.entryFee.setText("₹" + list.getEntryfee());
        holder.binding.teamtype.setText(list.getTeamtype());
        holder.binding.matchName.setText(list.getMatchName() + " - Match "+ list.getMatchno());
        holder.binding.matchMap.setText(list.getMap());

        Picasso.get().load(list.getImages()).placeholder(R.drawable.loading_img).into(holder.binding.matchImages);

        // OnClick Listener for Match Details
        holder.itemView.setOnClickListener(view -> {
            Intent intent = new Intent(mContext, ClaasicWinnerActivity.class);
            intent.putExtra("matchid", String.valueOf(list.getId()));
            intent.putExtra("gamename", list.getMatchName());
            intent.putExtra("date", list.getDate());
            intent.putExtra("time", list.getTime());
            intent.putExtra("images", list.getImages());
            intent.putExtra("matchno", list.getMatchno());
            mContext.startActivity(intent);
        });
    }

    @Override
    public int getItemCount() {
        return models.size();
    }

    public static class holder extends RecyclerView.ViewHolder {
        ResultMatchBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);
            binding = ResultMatchBinding.bind(itemView);
        }
    }
}